if(tutorial_settings == nil) then
  tutorial_settings = {played = false}
end
local played_in_past = tutorial_settings.played
state:on_save(function(save)
  tutorial_settings.played = true
  save:set("tutorial_settings", tutorial_settings)
end)

state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local generator_mirror = resize.location.std.generators[1].mirror:as_rectangled():expand(1);
local checker_mirror = resize.location.std.checkers[1].mirror:as_rectangled():expand(1);
local center_of_region = resize.location.user_rect:as_rectangled():center();

function highlight_input(c, fade)
  c:draw_rectangle(
    c.viewport:world_to_view(generator_mirror),
    {1.0, 1.0, 0.0, fade.progress * blinking_at_time(fade.total, 1) * 0.25}
  )
end
function highlight_output(c, fade)
  c:draw_rectangle(
    c.viewport:world_to_view(checker_mirror),
    {1.0, 1.0, 0.0, fade.progress * blinking_at_time(fade.total, 1) * 0.25}
  )
  draw_arrow_centered(c, c.viewport:world_to_view(center_of_region), 3 * c.viewport.zoom, RIGHT, {1, 1, 1, fade.progress * blinking_at_time(fade.total, 1)})
end

function tutorial_routine_first()
  return coroutine.wrap(function()
    set_user_input_filter(restrictive_filter)
    embed(announce("Welcome", 3, 0.3, captured_cancel()))
    embed(pause(0.5))
    embed(announce("Goal:", 3, 0.3, captured_cancel()))
    embed(ramp(3, do_all(highlight_input, announce_lambda("Move inputs...", 0.2)), captured_cancel()))
    embed(pause(0.5))
    embed(ramp(3, do_all(highlight_output, announce_lambda("...to output", 0.2)), captured_cancel()))
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(pause(0.5))
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.2))
    ))
    embed(ramp_until(function() return state.grid:ticks() >= 15 end, announce_lambda("Conveyors move objects", 0.15)))
    embed(ramp(3, announce_lambda("and so does gravity", 0.15)))
    embed(pause(0.5))
    embed(ramp_until(function() return false end, do_all(
      announce_lambda("Try again", 0.2),
      highlight_menu_item_lambda("stop_button")
    )))
  end)
end

function is_conveyor_selected()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialPlaceObject" then
    if partial.what.type == "Conveyor" then
      return true
    end
  end
end
local gap = resize.location.gap
function get_remaining_holes()
  local ret = {}
  for v in each_vector(gap) do
    if state.grid:at(v) == nil then
      table.insert(ret, v)
    end
  end
  return ret
end
function is_filling_gap()
  return #get_remaining_holes() > 0 and is_conveyor_selected()
end
function fill_in_gap(c, fade)
  for _, v in pairs(get_remaining_holes()) do
    local rect = c.viewport:world_to_view(Rectangle.new(v, v))
    c:draw_rectangle(
      rect,
      {0.0, 1.0, 0.0, fade.progress * (0.1 + fading_at_time(fade.total) * 0.3)}
    )
    draw_arrow_at_rect(
      c,
      rect,
      0.06 - 0.04 * bouncing_at_time(fade.total),
      c.viewport.zoom * 0.5,
      DOWN,
      {1, 1, 1, fade.progress}
    )
  end
end

local function only_conveyor_interaction(i)
  return i.type == "PlaceBlockAction" and i.block.type == "Conveyor"
end
local function only_place_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.lmb_click or i.type == MouseEventAction.rmb_click then
      return true
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
end

function tutorial_routine_second()
  return coroutine.wrap(function()
    embed(announce("Let's fix this factory.", 3, 0.1, captured_cancel()))
    state:suppress_toolbar_menu(false)
    embed(pause(0.5))
    while #get_remaining_holes() > 0 do
      set_user_input_filter(only_conveyor_interaction)
      embed(ramp_until(is_conveyor_selected, do_all(
        announce_lambda("Tool: Conveyor", 0.2),
        highlight_menu_item_lambda("toolbar_2")
      )))
      set_user_input_filter(only_place_interaction)
      embed(ramp_while(is_filling_gap, do_all(
        announce_lambda("Click and drag to place", 0.13),
        fill_in_gap
      )))
    end
    embed(tutorial_routine_finished())
  end)
end
function speed_is_low()
  return state:get_simulation_speed() < 1.5;
end
function speed_is_lowish()
  return state:get_simulation_speed() < 2.5;
end
function tutorial_routine_finished()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_cancel_filter)
    embed(ramp_while(is_conveyor_selected, announce_lambda("Right click to exit conveyor tool", 0.1)))
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.2))
    ))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(pause_until(function() return state.grid:ticks() >= 23 end))
    embed(announce("It works!", 3, 0.2, captured_cancel()))
    embed(ramp(3, do_all(
      announce_lambda("We must complete the quota.", 0.1),
      highlight_menu_item_lambda("quota_menu")
    ), captured_cancel()))
    embed(pause(1))
    embed(ramp_while(speed_is_low, do_all(
      announce_lambda("Increase the speed.", 0.15),
      announce_lambda("(Left click)", 0.08, -0.125),
      highlight_menu_item_lambda("speed_control")
    )))
    embed(ramp_while(speed_is_lowish, do_all(
      announce_lambda("Faster!", 0.2),
      announce_lambda("(Left click again)", 0.06, -0.15),
      highlight_menu_item_lambda("speed_control")
    )))
    embed(pause_until(function() return state.grid:ticks() >= 270 end))
  end)
end
function tutorial_routine()
  if not played_in_past then
    return tutorial_routine_first()
  elseif #get_remaining_holes() > 0 then
    return tutorial_routine_second()
  else
    return tutorial_routine_finished()
  end
end

draw_interpreted_routine(tutorial_routine())

state:filter_interactions(function(i)
  if i.type == "Place" then
    if i.what.type == "Conveyor" then
      if gap:contains(i.where.position) then
        if i.where.view.object_to_view == ID then
          return
        end
      end
    end
  elseif i.type == "Join" then
    return
  end
  return "This level only allows placing conveyors in designated area."
end)
